---
title: Confidence Intervals · Cloudflare Analytics docs
description: Confidence intervals help assess accuracy and quantify uncertainty
  in results from sampled datasets. When querying sum or count fields on
  adaptive datasets, you can request a confidence interval to understand the
  possible range around an estimate. For example, specifying a confidence level
  of 0.95 returns the estimate, along with the range of values that likely
  contains the true value 95% of the time.
lastUpdated: 2025-09-24T15:13:01.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/analytics/graphql-api/features/confidence-intervals/
  md: https://developers.cloudflare.com/analytics/graphql-api/features/confidence-intervals/index.md
---

Confidence intervals help assess accuracy and quantify uncertainty in results from sampled datasets. When querying sum or count fields on adaptive datasets, you can request a confidence interval to understand the possible range around an estimate. For example, specifying a confidence level of `0.95` returns the estimate, along with the range of values that likely contains the true value 95% of the time.

## Availability

* **Supported datasets**: Adaptive (sampled) datasets only.
* **Supported fields**: All `sum` and `count` fields.
* **Usage**: Confidence `level` must be provided as a decimal between 0 and 1 (for example,`0.90`, `0.95`, `0.99`).
* **Default**: If no confidence level is specified, intervals are not returned.

## Usage example

The following example shows how to query a confidence interval and interpret the response.

### Request

To request a confidence interval, use the `confidence(level: X)` argument in your query.

```graphql
query SingleDatasetWithConfidence($zoneTag: string, $start: Time, $end: Time) {
  viewer {
    zones(filter: {zoneTag: $zoneTag}) {
      firewallEventsAdaptiveGroups(
        filter: {datetime_gt: $start, datetime_lt: $end}
        limit: 1000
      ) {
        count
        avg {
          sampleInterval
        }
        confidence(level: 0.95) {
          count {
            estimate
            lower
            upper
            sampleSize
          }
        }
      }
    }
  }
}
```

[Run in GraphQL API Explorer](https://graphql.cloudflare.com/explorer?query=I4VwpgTgngBAygSwHYHMA2YAiBDALtgZzFwHUFcALAYQHskAzBAEzCQGMwAKAEgC86wAFWwoAXDAK4IyFABoY3Sdgi5xghAFsw87qyZrNYAJQwA3gCgYMAG4IwAd0hnLVmPyRgCnRmlyRxpu5CIuJ8AsIoAL4mFq6ujBAO2GhoAKLWrLgEAIJM2AAOuAgZAOIQNCD5Xi5xVj5+EAF5fkVaAPooqgpKKvLNxIZtvqF6kTW1aJrk4gCMAAwL41YxS65sFUi4q1bY1ijOtbUE2Br5GACSm5DWydswY4dW6wzMrBycGBlo4nMAdACcAFYVo81htcAdQa5PK08GA7nE0DRHBAEa5KvlIGirMdThhELx4VD7ncHrUyVYyWNIkA\&variables=N4IgXg9gdgpgKgQwOYgFwgFoHkByBRAfQEkAREAGhAGcAXBAJxrRACYAGFgVgFoBGXvmzhsAHKhYBmVBN4YKIGFAAmzdlz4DeQ3gBZxUmXIC+QA)

### Response

The response includes the following values:

* `estimate`: The estimated value, based on sampled data.
* `lower`: The lower bound of the confidence interval.
* `sampleSize`: The number of sampled data points used to calculate the estimate.
* `upper`: The upper bound of the confidence interval.

In this example, the interpretation of the response is that, based on a sample of 40,054, the estimated number of events is 42,939, with 95% confidence that the true value lies between 42,673 and 43,204.

```json
{
  "data": {
    "viewer": {
      "zones": [
        {
          "firewallEventsAdaptiveGroups": [
            {
              "avg": {
                "sampleInterval": 1.0720277625205972
              },
              "confidence": {
                "count": {
                  "estimate": 42939,
                  "lower": 42673.44115335711,
                  "sampleSize": 40054,
                  "upper": 43204.55884664289
                }
              },
              "count": 42939
            }
          ]
        }
      ]
    }
  },
  "errors": null
}
```
