---
title: Examples · Cloudflare Durable Objects docs
description: Explore the following examples for Durable Objects.
lastUpdated: 2025-08-14T13:46:41.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/durable-objects/examples/
  md: https://developers.cloudflare.com/durable-objects/examples/index.md
---

Explore the following examples for Durable Objects.

[Use the Alarms API](https://developers.cloudflare.com/durable-objects/examples/alarms-api/)

[Use the Durable Objects Alarms API to batch requests to a Durable Object.](https://developers.cloudflare.com/durable-objects/examples/alarms-api/)

[Build a counter](https://developers.cloudflare.com/durable-objects/examples/build-a-counter/)

[Build a counter using Durable Objects and Workers with RPC methods.](https://developers.cloudflare.com/durable-objects/examples/build-a-counter/)

[Build a rate limiter](https://developers.cloudflare.com/durable-objects/examples/build-a-rate-limiter/)

[Build a rate limiter using Durable Objects and Workers.](https://developers.cloudflare.com/durable-objects/examples/build-a-rate-limiter/)

[Durable Object in-memory state](https://developers.cloudflare.com/durable-objects/examples/durable-object-in-memory-state/)

[Create a Durable Object that stores the last location it was accessed from in-memory.](https://developers.cloudflare.com/durable-objects/examples/durable-object-in-memory-state/)

[Durable Object Time To Live](https://developers.cloudflare.com/durable-objects/examples/durable-object-ttl/)

[Use the Durable Objects Alarms API to implement a Time To Live (TTL) for Durable Object instances.](https://developers.cloudflare.com/durable-objects/examples/durable-object-ttl/)

[Use ReadableStream with Durable Object and Workers](https://developers.cloudflare.com/durable-objects/examples/readable-stream/)

[Stream ReadableStream from Durable Objects.](https://developers.cloudflare.com/durable-objects/examples/readable-stream/)

[Use RpcTarget class to handle Durable Object metadata](https://developers.cloudflare.com/durable-objects/examples/reference-do-name-using-init/)

[Access the name from within a Durable Object using RpcTarget.](https://developers.cloudflare.com/durable-objects/examples/reference-do-name-using-init/)

[Testing with Durable Objects](https://developers.cloudflare.com/durable-objects/examples/testing-with-durable-objects/)

[Write tests for Durable Objects.](https://developers.cloudflare.com/durable-objects/examples/testing-with-durable-objects/)

[Durable Objects - Use KV within Durable Objects](https://developers.cloudflare.com/durable-objects/examples/use-kv-from-durable-objects/)

[Read and write to/from KV within a Durable Object](https://developers.cloudflare.com/durable-objects/examples/use-kv-from-durable-objects/)

[Build a WebSocket server with WebSocket Hibernation](https://developers.cloudflare.com/durable-objects/examples/websocket-hibernation-server/)

[Build a WebSocket server using WebSocket Hibernation on Durable Objects and Workers.](https://developers.cloudflare.com/durable-objects/examples/websocket-hibernation-server/)

[Build a WebSocket server](https://developers.cloudflare.com/durable-objects/examples/websocket-server/)

[Build a WebSocket server using Durable Objects and Workers.](https://developers.cloudflare.com/durable-objects/examples/websocket-server/)
