---
title: Code blocks · Cloudflare Style Guide
description: |-
  Code blocks are powered by Expressive Code, a project by Astro.
  This is just a small showcase of the wide functionality of this component.
lastUpdated: 2025-09-15T14:13:17.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/components/code/
  md: https://developers.cloudflare.com/style-guide/components/code/index.md
---

Code blocks are powered by [Expressive Code](https://expressive-code.com/), a project by Astro. This is just a small showcase of the wide functionality of this component.

Learn more about formatting in the [code block formatting guide](https://developers.cloudflare.com/style-guide/formatting/code-conventions-and-format/).

Warning

Do not use the `$` sign in your code blocks before the command.

## Output

If you would like to include the output of your code block, create a second code block below and add the `output` property to the opening code fence.

```sh
npx wrangler vectorize create tutorial-index --dimensions=3 --metric=cosine
```

```sh
✅ Successfully created index 'tutorial-index'


[[vectorize]]
binding = "VECTORIZE_INDEX" # available in your Worker on env.VECTORIZE_INDEX
index_name = "tutorial-index"
```

````mdx
```sh
npx wrangler vectorize create tutorial-index --dimensions=3 --metric=cosine
```


```sh output
✅ Successfully created index 'tutorial-index'


[[vectorize]]
binding = "VECTORIZE_INDEX" # available in your Worker on env.VECTORIZE_INDEX
index_name = "tutorial-index"
```
````

## Workers Playground

If you add the `playground` option to the opening code fence for a Worker example, it will add a "Run Worker in Playground" link that will take the user to the [Worker's playground](https://developers.cloudflare.com/workers/playground/)

### Live demo

```js
export default {
  fetch() {
    return new Response("Test!");
  },
};
```

[Run Worker in Playground](https://workers.cloudflare.com/playground#LYVwNgLglgDghgJwgegGYHsHALQBM4RwDcABAEbogB2+CAngLzbPYZb6HbW5QDGU2AAwBGYQFYA7MIBMAFgCcs2QGYAXCxZtgHOFxp8BI8VLmKVAWABQAYXRUIAU3vYAIlADOMdO6jQ7qki08AmISKjhgBwYAIigaBwAPADoAK3do0lQoMCcIqNj45LToq1t7JwhsABU6GAcAuBgYMD4CKDtkFLgANzh3XgRYCABqYHRccAcrK0SvJBJcB1Q4cAgSAG9LEkCHCF4ACwAKAEoNre2SBF2QBCowhwB3EgAlB087dwdD6Kq3iABCaLHIjnAC+ABpLKCiFYNMwtDo9Dx+EJRJIZAolMpSnZHM43O8fH4qAEgjpSOFIjFIoQdBlAtlclTomQwOgyCUbLiKtVavUSI1mq1iZ13HZppZ1tFgHA4gB9MYTHLRVQFRZFdKg2FwhEhJEGVHGDFmZTMKxAA)

### How to use

````mdx
```js playground
export default {
  fetch() {
    return new Response("Test!");
  },
};
```
````

[Run Worker in Playground](https://workers.cloudflare.com/playground#LYVwNgLglgDghgJwgegGYHsHALQBM4RwDcABAEbogB2+CAngLzbPYZb6HbW5QDGU2AAwAWUQCYArAGYA7AEYAHBLEAuFizbAOcLjT4CR46fKViAsACgAwuioQApnewARKAGcY6N1Gi2VJTTwCYhIqOGB7BgAiKBp7AA8AOgArNyjSVCgwR3DImLik1KjLGztHCGwAFToYe384GBgwPgIoW2RkuAA3ODdeBFgIAGpgdFxwe0tLAANZ1JImuDoAcwRKGgsEzyQSXHtUOHAIEgBvCxIA+wheAAsACgBKU-OLkgQrkAQqUPsAdxIAEr2Dy2Nz2O5RSrAiAAQiiDyILwAvgAaCxIxGzaaWdTMTTaXQ8fhCUTCSSyRTKEq2BxOVwg7y+Kj+QLaUhhCLRCKEbTpAJZHKcqJkMDoMjFaw08pVGp1EgNJotJkdNy2KYWE5RYBwWIAfVG42yURU+T2hTSSJxuPxwUJ+hJRgppmYliAA)

## GraphQL API Explorer

Add `graphql-api-explorer` to the opening code fence to create a `graphql` code block with a **Run in GraphQL API Explorer** button that leads to [GraphQL API Explorer](https://graphql.cloudflare.com/explorer).

Note

This button only works if the person selecting it is logged in or has an API token saved.

### Variables

In the GraphQL API Explorer, the **Variables** section is automatically filled based on the names and types of the variables defined in your query:

* Variables that include `start` and are of type `Time` are set to six hours before the current time
* Variables that include `end` and are of type `Time` are set to the current time
* Variables that include `start` and are of type `Date` are set to 24 hours before the current date
* Variables that include `end` and are of type `Date` are set to the current date
* Variables that include `zoneTag` and are of type `string` are set to "ZONE\_ID"
* Variables that include `accountTag` and are of type `string` are set to "ACCOUNT\_ID"
* Variables that include `id` and are of type `string` are set to "REPLACE\_WITH\_ID"
* Variables that include `limit` and are of type `int` are set to 100
* Any other variable with a type of `string` is set to "REPLACE\_WITH\_STRING"

You can also add custom variables by setting their values as a JSON string in the `graphql-api-explorer` metadata. The custom variables will be merged with the automatically populated variables.

In the following example, the custom value is `custom-variable`:

````mdx
```graphql graphql-api-explorer='{"uID": "custom-variable"}' title="A GraphQL query"
query GraphqlExample($zoneTag: string, $start: Time, $end: Time) {
 viewer {
   zones(filter: { zoneTag: $zoneTag }) {
     ...
   }
 }
}
```
````

So, the **Variables** would look something like this:

```plaintext
{"zoneTag":"ZONE_ID", "start":"2025-09-11T14:00:00Z", "end":"2025-09-11T20:00:00Z", "uId": "custom-variable"}
```
